#include <LiquidCrystal.h>  // inclus dans le fichier source la bibliothèque de gestion d'un afficheur lcd

//constantes symboliques pour les entrées/sorties
#define E 4
#define RS 5
#define D4 3
#define D5 2
#define D6 1
#define D7 0
#define TEMP_PIN A2

LiquidCrystal monlcd(RS, E, D4, D5, D6, D7);  // on construit l'objet monlcd à partir de la classe LiquidCrystal

void setup() {
  monlcd.begin(16, 2);  // initialise l'objet au format de l'afficheur utilisé : 16 colonnes et 2 lignes  
}

void loop() {
  int N = analogRead(TEMP_PIN);
  float temperature, Us;
  Us = N * 5.0 / 1024;
  temperature = 100 * Us;
  monlcd.setCursor(0, 0);
  monlcd.print("N : ");
  monlcd.print(N);
  monlcd.print("   ");
  monlcd.setCursor(0, 1);
  monlcd.print(temperature);
  monlcd.print(' ');
  monlcd.print(char(0xDF));  // pour le caractère °
  monlcd.print("C  ");       // pour nettoyer les caractères persistants

  delay(100);
}
