#include <LiquidCrystal.h> // inclus dans le fichier source la bibliothèque de gestion d'un afficheur lcd

//on  associe les signaux d'entrées et de sortie à obtenir aux pattes de la carte UNO
#define E 11
#define RS 12
#define D4 5
#define D5 4
#define D6 3
#define D7 2
#define TEMP_NTC A0


LiquidCrystal monlcd(RS, E, D4, D5, D6, D7); // on construit l'objet monlcd à partir de la classe LiquidCrystal

void setup() {
  monlcd.begin(16, 2); // initialise l'objet au format de l'afficheur utilisé : 16 colonnes et 2 lignes
  monlcd.print("BTS SN2-Digital");
  monlcd.setCursor(0, 1);
  monlcd.print("   thermometer");
  delay(1000);
  monlcd.clear();
  monlcd.print("Temp = ");
}

void loop() {
  monlcd.setCursor(7, 0); // Pour positionner le curseur juste après "Temp = "
  monlcd.print(char(0xDF)); // Pour afficher le caractère °
  monlcd.print("C");
  monlcd.print("        "); // On efface les caractères inutiles
  delay(100);
}
