#ifndef _game_h
#define _game_h

/*
 Classe gérant les échanges entre le jeu snake 3D et la carte Arduino Uno 
 @author: Livio SEMERARO
 @version: v1.0
 @date: 21/11/24
*/
class Game {

private:
  // Trans control command, range 128 ~ 255
  const byte transStart = 128;
  const byte transEnd = 129;
  // General command, range 0 ~ 127
  // The even command is sent by the requesting party
  // The odd command is sent by the responding party
  // Request echo, to confirm the device
  const byte requestEcho = 0;  // Comm
  // Respond echo, to tell this is the device
  const byte echo = 1;  // Comm
  // Request n analog values
  const byte requestAnalogs = 12;  // Comm n
  // Respond n analog values
  const byte analogs = 13;  // Comm A1/100 A1%100 ... An/100 An%100
  bool isConnected = false;
  int connectCode[3] = { transStart, echo, transEnd };
  int commande;

public:

  /*
   Permet au jeu snake 3D de détecter la présence de la carte Uno.
   La led intégrée 13 s'allume si la carte est connectée au jeu.
  */
  void connectArduinoToSnake() {
    if (Serial.available() > 0 && !isConnected && Serial.read() == requestEcho) {
      isConnected = true;
      for (int i; i < 3; i++) {
        Serial.write(connectCode[i]);
      }
      // Temoin visuel de la connexion au jeu
      digitalWrite(13, HIGH);
    }
  }

  /*
   Si la connexion est établie, envoi au bon format des valeures x et y du joystick 
   FORMAT : { transStart, x/128, x%128, y/128, y%128, transEnd }
  */
  void sendJoystickValues(const byte start, byte msb_x, byte lsb_x, byte msb_y, byte lsb_y, const byte stop) {
    if (isConnected) {
      // Lire la requête envoyée par le jeu snake
      commande = Serial.read();
      // Si la requête correspond à la lecture de broches analogiques
      if (commande == requestAnalogs) {
        Serial.write(start);
        Serial.write(analogs);
        Serial.write(msb_x);
        Serial.write(lsb_x);
        Serial.write(msb_y);
        Serial.write(lsb_y);
        Serial.write(stop);
      }
    }
  }
};

#endif
