const { writeFileSync, existsSync } = require('fs');

const packagePath = './package.json';
if (!existsSync(packagePath)) {
  console.log('\tDoes not contain a package.json file\n'.underline.red);
  return;
}
let packageJson = require(packagePath);

if (packageJson['publishConfig']['registry']) {
  packageJson['publishConfig']['registry'] =
'https://npm.cloudsmith.io/iniationware-gmbh/p4nrci/';

  writeFileSync(packagePath, JSON.stringify(packageJson, null, 2), {
encoding: 'utf8', flag: 'w' });
}