/****************************************************
  /* Envoyer un message NAVTEX sur la carte émission
  /* 30/08/2016
  /* Arduino Mega 2560 et UNO
  /* Pat
  /* V0.2
  /* emission d'un message unique. Reset pour renvoyer
  /* V1.0 14/10/2019 ligne 210 forçage synchro premier bit
  /****************************************************/
#include "Arduino.h"


#define LF   0x0A
#define CR   0x0D
#define SP   0x20
#define PIPE 0x7C

#define NSI  0x36  //navtex inversion chiffre shift in
#define NSO  0x2D  //navtex inversion lettre shift out


// Connexions
const int horloge = 2;
const int signal = 3;
volatile int top = LOW;

/****************************************************
  /*
  /*  Fonctions
  /*
  /****************************************************/

void routineTop() {
  top = HIGH;
}

// Envoi du message  sur le port série arduino de programmation  pour contrôle
// formater selon base_aff 0: caractère, HEX hexadécimal, BIN binaire, OCT octal, DEC décimal
void envoyer_message_com(byte * message, int base_aff) {
  int k = 0;

  while (message[k] != 0) {
    if ((message[k] == 0x0A || message[k] == 0x0D) && base_aff == 0)
      message[k] = 0x20;  //Ignorer CR et LF
    Serial.print(message[k], base_aff);
    Serial.write(' ');
    k++;
  }
  Serial.println("\n---------------------------------------------------------");
}

void convertir_modeB(byte * trame_modeB, const byte * message) {
  int i = 0;
  int j = 0;

  while (message[i] != 0x74) {
    trame_modeB[j] = message[i];
    trame_modeB[j + 5] = message[i];
    i++;
    j = j + 2;
  }
  trame_modeB[j] = 0;
  // remplissage des premiers caractères de répétition
  trame_modeB[1] = 0x78;
  trame_modeB[3] = 0x78;
}

void envoyer_caractere_navtex(byte caractere) {
  int masque = 0x40;
  int decal = 0;
  int unbit = 0;
  //top = 0;
  for (decal = 0; decal < 7; decal++) {
    unbit = caractere & masque;
    while (top != 1) { }; //attendre la validation du front montant
    digitalWrite(signal, unbit);
    masque = masque >> 1;
    top = 0;
  }
}

void mise_en_phase() {
  int i = 5; //10 x 14 bits x 10 ms =  1,4s de mise en phase
  while (i != 0) {
    envoyer_caractere_navtex(0X33);
    envoyer_caractere_navtex(0X78);
    i--;
  }
}

void envoyer_trame(const byte * trame) {
  int i = 0;
  while (trame[i] != 0) {
    envoyer_caractere_navtex(trame[i]);
    Serial.print(trame[i], HEX);
    Serial.print(" ");
    i++;
  }
  Serial.println("\r\n\n");
}

byte trame_modeB[180];
/*********************************************
  /*
  /*  Programme principal
  /*
  /*********************************************/

void setup() {
  // Initialisation E/S
  pinMode(horloge, INPUT);
  pinMode(signal, OUTPUT);
  digitalWrite(signal, 0);

  //Pour debug
  Serial.begin(9600);

  //Interruption entrée externe pour synchroniser l'envoi des données sur le front montant de l'horloge
  attachInterrupt(digitalPinToInterrupt(horloge), routineTop, RISING);



  // Variables
  int i, j, indice;
  char lettresChiffres = 'L';  //mémorisation état du shift
  char caractere;
  char caractere_navtex;

  byte message_txt[60] = "\r\nZCZC WA13\r\n061017 UTC OCT 16\r\nTest\r\nNNNN\r\n\n";

  byte message_navtex[120];



  /* tableau de conversion code ASCII des codes 41hex … 5ahex et 61hex … 7Ahex: lettres en code navtex*/
  char tab_lettres[26] = {0x71, 0x27, 0x5c, 0x65, 0x35, 0x6c, 0x56, 0x4b, 0x59, 0x74, 0x3c, 0x53, 0x4e, 0x4d, 0x47, 0x5a, 0x3a, 0x55, 0x69, 0x17, 0x39, 0x1e, 0x72, 0x2e, 0x6a, 0x63};

  /* tableau de conversion des signes et des chiffres. Les signes qui n'existent pas en code navtex sont remplacés par des espaces. BELL et bande perforée ne sont pas codées */
  char tab_chiffres[32] = {0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x69, 0x3c, 0x53, 0x1d, 0x63, 0x4d, 0x71, 0x4e, 0x2e, 0x5a, 0x3a, 0x72, 0x35, 0x55, 0x17, 0x6a, 0x39, 0x59, 0x47, 0x5c, 0x1d, 0x1d, 0x1e, 0x1d, 0x27, 0x1d};



  j = 0;
  i = 0;
  while (message_txt[i] != 0) {
    //Code ascii à traiter individuellement
    if (message_txt[i] == SP)
      message_navtex[j] = 0x1d;

    else if (message_txt[i] == LF)
      message_navtex[j] = 0x1B;

    else if (message_txt[i] == CR)
      message_navtex[j] = 0x0F;

    else if (message_txt[i] == PIPE) {
      if (lettresChiffres == 'L') {
        lettresChiffres = 'C';
        message_navtex[j] = NSI;
        j++;
      }
      message_navtex[j] = 0x65;
    }
    // si le caractère est un signe ou un chiffre
    else if (message_txt[i] > 0x20 && message_txt[i] < 0x41) {
      if (lettresChiffres == 'L') {
        lettresChiffres = 'C';
        message_navtex[j] = NSI;
        j++;
      }
      indice = message_txt[i] - 0x21;
      message_navtex[j] = tab_chiffres[indice];
    }
    // si le caractère est une lettre majuscule
    else if (message_txt[i] > 0x40 && message_txt[i] < 0x5B) {
      if (lettresChiffres == 'C') {
        lettresChiffres = 'L';
        message_navtex[j] = NSO;
        j++;
      }
      indice = message_txt[i] - 0x41;
      message_navtex[j] = tab_lettres[indice];
    }

    // si le caractère est une lettre minuscule
    else if (message_txt[i] > 0x60 && message_txt[i] < 0x7B) {
      if (lettresChiffres == 'C') {
        lettresChiffres = 'L';
        message_navtex[j] = NSO;
        j++;
      }
      indice = message_txt[i] - 0x61;
      message_navtex[j] = tab_lettres[indice];
    }
    j++;
    i++;

  }
  message_navtex[j] = 0x74;   //fin du message
  message_navtex[j + 1] = 0; //fin du message pour l'affichage

  /******************************************************************************/
  /* Programme principal                                                        */
  /******************************************************************************/

  convertir_modeB(trame_modeB, message_navtex);
  envoyer_message_com(message_txt, HEX);
  envoyer_message_com(message_navtex, HEX);
  envoyer_message_com(trame_modeB, HEX);
  top = 0; // pour ne pas perdre le premier bit
  mise_en_phase();
  envoyer_trame(trame_modeB);

}



void loop() {
  
}

