#include <TimerOne.h>

#define PIN_POWER_ON 9  // Actif à l'état haut
#define PIN_BP_MA 2

void setup() {
  // put your setup code here, to run once:
  pinMode(PIN_POWER_ON, OUTPUT);
  Timer1.attachInterrupt(poweroff);
  digitalWrite(PIN_POWER_ON, HIGH);
  Timer1.stop();
  attachInterrupt(0, buttonActionned, CHANGE);
}

void loop() {
  // put your main code here, to run repeatedly:
}

/***************************************************************/
/*  ISR appelée lors d'un appui sur le bouton Marche / arrêt   */
/***************************************************************/
void buttonActionned() {
  if (digitalRead(PIN_BP_MA)) {    
    Timer1.initialize(2000000);
    Timer1.resume();
  }
}

/*********************************************************/
/*  ISR appelée à la fin de la temporisation de 2 s      */
/*********************************************************/
void poweroff() {
  if (digitalRead(PIN_BP_MA))
    digitalWrite(PIN_POWER_ON, LOW);
}
